package net.w_horse.excelpojo.xml;

import net.w_horse.excelpojo.excel.cellseeker.LabeledCellSeeker;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class LabeledCellSeekerFactoryBean extends AbstractCellSeekerFactoryBean {

	private String label;
	private String retrieveFrom;
	private String margedLabel;
	private boolean margedRows = false;

	@Override
	public Object getObject() throws Exception {
		LabeledCellSeeker seeker = new LabeledCellSeeker();
		seeker.setLabel(getLabel());
		seeker.setRetrieveFrom(getRetrieveFrom());
		seeker.setMargedRows(isMargedRows());
		seeker.setMargedLabel(getMargedLabel());
		seeker.setUse(getUse());
		seeker.setRange(getRange());
		seeker.setConverter(getConverter());

		return seeker;
	}

	@Override
	public Class<LabeledCellSeeker> getObjectType() {
		return LabeledCellSeeker.class;
	}

	@Override
	BeanDefinitionBuilder parse(Element element,
			CellSeekerFactoryBeanAcceptableXMLParser parser,
			ParserContext parserContext) {
		return parser.parse(element, this, parserContext);
	}

	public void setLabel(String label) {
		this.label = label;
	}

	public String getLabel() {
		return label;
	}

	public void setRetrieveFrom(String retrieveFrom) {
		this.retrieveFrom = retrieveFrom;
	}

	public String getRetrieveFrom() {
		return retrieveFrom;
	}

	public void setMargedLabel(String margedLabel) {
		this.margedLabel = margedLabel;
	}

	public String getMargedLabel() {
		return margedLabel;
	}

	public boolean isMargedRows() {
	    return margedRows;
	}

	public void setMargedRows(boolean margedRows) {
		this.margedRows = margedRows;
	}
}
